


trigger_utility = 
{

-------------------------------------------------
--	        TriggerFunctions
init = function(trigger_id)
calls.enter("trigger_utility.init",trigger_id)
	local trigger = Triggers[trigger_id]
	if (trigger.active == nil) then
		trigger.active = true
	end
	if (trigger.activate == nil) then
		trigger.activate = function() end
	end
calls.leave("trigger_utility.init",trigger_id)
end, 
--	   
loadActiveFlag = function(trigger_id, value)
calls.enter("trigger_utility.loadActiveFlag",trigger_id)
	local trigger = Triggers[trigger_id]
	if (trigger ~= nil) then
		if (trigger.type == "quest") then
			trigger.active = value
		else
			log("main", "    -quest ")
		end
	else
		log("main", "     ")
	end
calls.leave("trigger_utility.loadActiveFlag",trigger_id)
end, 

-------------------------------------------------
--	
--	    trigger_id (      )
resetDelay = function(trigger_id)
calls.enter("trigger_utility.resetDelay",trigger_id)
	local trigger = Triggers[trigger_id]
	trigger.start_time_for_delay = time()
calls.leave("trigger_utility.resetDelay",trigger_id)
end, 
--	true   time_       trigger_id
delay = function(trigger_id, time_)
calls.enter("trigger_utility.delay",trigger_id)
	local trigger = Triggers[trigger_id]
	if (trigger.start_time_for_delay == nil) then
		--	first time
		trigger.start_time_for_delay = time()
calls.leave("trigger_utility.delay",trigger_id)
		return false
	else
		if (time() > (trigger.start_time_for_delay + time_)) then
calls.leave("trigger_utility.delay",trigger_id)
			return true
		end
calls.leave("trigger_utility.delay",trigger_id)
		return false
	end
end, 
--	  
loadDelayStartTime = function(trigger_id, value)
calls.enter("trigger_utility.loadDelayStartTime",trigger_id)
	local trigger = Triggers[trigger_id]
	if (trigger ~= nil) then
		if (trigger.type == "quest") then
			trigger.start_time_for_delay = value
		else
			log("main", "    -quest ")
		end
	else
		log("main", "     ")
	end
calls.leave("trigger_utility.loadDelayStartTime",trigger_id)
end, 

--	    
loadStartWaitingTime = function(trigger_id, value)
calls.enter("trigger_utility.loadStartWaitingTime",trigger_id)
	local trigger = Triggers[trigger_id]
	if (trigger ~= nil) then
		if (trigger.type == "HMG_position") then
			trigger.start_waiting = value
		else
			log("main", "    -HMG ")
		end
	else
		log("main", "     ")
	end
calls.leave("trigger_utility.loadStartWaitingTime",trigger_id)
end, 

--	    
loadOverruningFlag = function(trigger_id, value)
calls.enter("trigger_utility.loadOverruningFlag",trigger_id)
	local trigger = Triggers[trigger_id]
	if (trigger ~= nil) then
		if (trigger.type == "HMG_position") then
			trigger.overruning_persons = value
		else
			log("main", "    -HMG ")
		end
	else
		log("main", "     ")
	end
calls.leave("trigger_utility.loadOverruningFlag",trigger_id)
end,

-------------------
loadTNTtrigger = function(id,arm,cndw,def,cst,dst,sp,sst,ttd,sdt,sr,er,exr,dmg,x_,y_,z_,sap,team)
calls.enter("trigger_utility.loadTNTtrigger",id)
	Triggers[id].armed = arm
	Triggers[id].countdown = cndw
	Triggers[id].defuse = def
	Triggers[id].countdown_start_time = cst
	Triggers[id].defuse_start_time = dst
	Triggers[id].spotting_probability = sp
	Triggers[id].saper_defuse_time = sdt
	Triggers[id].shout_radius = sr
	Triggers[id].effect_radius = er
	Triggers[id].explode_radius = exr
	Triggers[id].damage = dmg
	Triggers[id].position = {x=x_,y=y_,z=z_,f=1}
	Triggers[id].saper = sap
	Triggers[id].team = team
calls.leave("trigger_utility.loadTNTtrigger",id)	
end,
-------------------------------------------------
--	   
--	 
isPersonPresent = function(trigger_id, person_id)
calls.enter("trigger_utility.isPersonPresent",trigger_id)
	local trigger = Triggers[trigger_id]
	local persons = trigger_service.personsInTrigger(trigger_id)
	-------------------------------------------------
	local find_func = function(index, value)
		if (value == person_id) then
			return 1
		end
	end
	-------------------------------------------------
calls.leave("trigger_utility.isPersonPresent",trigger_id)
	if (table.foreach(persons, find_func) == 1) then
		return true
	end
	return false
end, 
--   
isPlayerPresent = function(trigger_id, player_id)
calls.enter("trigger_utility.isPlayerPresent",trigger_id)
	local trigger = Triggers[trigger_id]
	local persons = trigger_service.personsInTrigger(trigger_id)
	-------------------------------------------------
	local find_func = function(index, value)
		if (team(value) == player_id) then
			return 1
		end
	end
	-------------------------------------------------
calls.leave("trigger_utility.isPlayerPresent",trigger_id)
	if (table.foreach(persons, find_func) == 1) then
		return true
	end
	return false
end, 
--     
isPlayerCountPresent = function(trigger_id, player_id, count)
calls.enter("trigger_utility.isPlayerCountPresent",trigger_id)
	local trigger = Triggers[trigger_id]
	local persons = trigger_service.personsInTrigger(trigger_id)
	local counter = 0
	-------------------------------------------------
	local find_func = function(index, value)
		if (team(value) == player_id) then
			counter = counter + 1
		end
	end
	-------------------------------------------------
	table.foreach(persons, find_func)
calls.leave("trigger_utility.isPlayerCountPresent",trigger_id)
	return (counter >= count)
end, 
--     
isPlayerPercentsPresent = function(trigger_id, player_id, percents)
calls.enter("trigger_utility.isPlayerPercentsPresent",trigger_id)
	local trigger = Triggers[trigger_id]
	local persons = trigger_service.personsInTrigger(trigger_id)
	local counter = 0
	-------------------------------------------------
	local find_func = function(index, value)
		if (team(value) == player_id) then
			if (IsAlive(value)) then
				counter = counter + 1
			end
		end
	end
	-------------------------------------------------
	table.foreach(persons, find_func)
	local all_counter = 0
	-------------------------------------------------
	local find_func2 = function(index, value)
		if (value.team_id == player_id) then
			if (IsAlive(index)) then
				all_counter = all_counter + 1
			end
		end
	end
	-------------------------------------------------
	table.foreach(Humans, find_func2)
	local ratio = counter / all_counter
calls.leave("trigger_utility.isPlayerPercentsPresent",trigger_id)
	return (ratio >= percents)
end, 
--      
isEnemyPercentsPresent = function(trigger_id, player_id, percents)
calls.enter("trigger_utility.isEnemyPercentsPresent",trigger_id)
	local trigger = Triggers[trigger_id]
	local persons = trigger_service.personsInTrigger(trigger_id)
	local counter = 0
	-------------------------------------------------
	local find_func = function(index, value)
		local tmp_team = team(value)
		if (tmp_team ~= player_id) then
			if (relations(tmp_team, player_id) == "enemy") then
				if (IsAlive(value)) then
					counter = counter + 1
				end
			end
		end
	end
	-------------------------------------------------
	table.foreach(persons, find_func)
	local all_counter = 0
	-------------------------------------------------
	local find_func2 = function(index, value)
		if (value.team_id ~= player_id) then
			if (relations(value.team_id, player_id) == "enemy") then
				if (IsAlive(index)) then
					all_counter = all_counter + 1
				end
			end
		end
	end
	-------------------------------------------------
	table.foreach(Humans, find_func2)
	local ratio = counter / all_counter
calls.leave("trigger_utility.isEnemyPercentsPresent",trigger_id)
	return (ratio >= percents)
end, 

-------------------------------------------------
--	  
--	  
isTriggerActive = function(another_trigger_id)
calls.enter("trigger_utility.isTriggerActive",another_trigger_id)
	local trigger = Triggers[another_trigger_id]
	if (trigger == nil) then
		log("isTriggerActive", "   ["..another_trigger_id.."]")
        end
	if (trigger.active ~= nil) then
calls.leave("trigger_utility.isTriggerActive",another_trigger_id)
		return trigger.active
	end
calls.leave("trigger_utility.isTriggerActive",another_trigger_id)
	return false
end, 

-------------------------------------------------
--	 
--	  
isPersonHurted = function(person_id)
calls.enter("trigger_utility.isPersonHurted",person_id)
	local memory_table = trigger_service.hurt_observer.hurts
	-------------------------------------------------
	local find_func = function(id, owner_id)
		if (id == person_id) then
			return 1
		end
	end
	-------------------------------------------------
	if (table.foreach(memory_table, find_func) == 1) then
calls.leave("trigger_utility.isPersonHurted",person_id)
		return true
	end
calls.leave("trigger_utility.isPersonHurted",person_id)
	return false
end, 
--	  
isPersonKilled = function(person_id)
calls.enter("trigger_utility.isPersonKilled",person_id)
	local memory_table = trigger_service.hurt_observer.deaths
	-------------------------------------------------
	local find_func = function(id, time)
		if (id == person_id) then
			return 1
		end
	end
	-------------------------------------------------
	if (table.foreach(memory_table, find_func) == 1) then
calls.leave("trigger_utility.isPersonKilled",person_id)
		return true
	end
calls.leave("trigger_utility.isPersonKilled",person_id)
	return false
end, 
--      
isPlayerPercentsKilled = function(trigger_id, player_id, percents)
calls.enter("trigger_utility.isPlayerPercentsKilled",trigger_id)
--	log(trigger_id, "    ")
--	log(trigger_id, " ["..player_id.."],  ["..percents.."]")
	local trigger = Triggers[trigger_id]
	local persons = trigger_service.hurt_observer.deaths
	local counter = 0
	-------------------------------------------------
	local find_func = function(index, value)
		if (team(index) == player_id) then
			counter = counter + 1
		end
	end
	-------------------------------------------------
	table.foreach(persons, find_func)
--	log(trigger_id, "  ["..counter.."]")
	--  counter     
	local all_counter = 0
	-------------------------------------------------
	local find_func2 = function(index, value)
		if (value.team_id == player_id) then
			all_counter = all_counter + 1
		end
	end
	-------------------------------------------------
	table.foreach(Humans, find_func2)
--	log(trigger_id, "  ["..all_counter.."]")
	--  all_counter      
	local ratio = counter / all_counter
--	log(trigger_id, " = ["..ratio.."]")
calls.leave("trigger_utility.isPlayerPercentsKilled",trigger_id)
	return (ratio >= percents)
end, 
--       
isEnemyPercentsKilled = function(trigger_id, player_id, percents)
calls.enter("trigger_utility.isEnemyPercentsKilled",trigger_id)
--	log(trigger_id, "    ")
--	log(trigger_id, " ["..player_id.."],  ["..percents.."]")
	local trigger = Triggers[trigger_id]
	local persons = trigger_service.hurt_observer.deaths
	local counter = 0
	-------------------------------------------------
	local find_func = function(index, value)
		local tmp_team = team(index)
		if (tmp_team ~= player_id) then
			if (relations(tmp_team, player_id) == "enemy") then
				counter = counter + 1
			end
		end
	end
	-------------------------------------------------
	table.foreach(persons, find_func)
--	log(trigger_id, "  ["..counter.."]")
	--  counter     
	local all_counter = 0
	-------------------------------------------------
	local find_func2 = function(index, value)
		if (value.team_id ~= player_id) then
			if (relations(value.team_id, player_id) == "enemy") then
				all_counter = all_counter + 1
			end
		end
	end
	-------------------------------------------------
	table.foreach(Humans, find_func2)
--	log(trigger_id, "  ["..all_counter.."]")
	--  all_counter      
	local ratio = counter / all_counter
--	log(trigger_id, " = ["..ratio.."]")
calls.leave("trigger_utility.isEnemyPercentsKilled",trigger_id)
	return (ratio >= percents)
end, 
--	 
isUnderFire = function(person_id)
calls.enter("trigger_utility.isUnderFire",person_id)
	local memory_table = trigger_service.person_observer.underfire
	-------------------------------------------------
	local find_func = function(id, time)
		if (id == person_id) then
			return 1
		end
	end
	-------------------------------------------------
	if (table.foreach(memory_table, find_func) == 1) then
calls.leave("trigger_utility.isUnderFire",person_id)
		return true
	end
calls.leave("trigger_utility.isUnderFire",person_id)
	return false
end, 
--	 
seeEnemy = function(person_id)
calls.enter("trigger_utility.seeEnemy",person_id)
	local memory_table = trigger_service.person_observer.enemies
	-------------------------------------------------
	local find_func = function(id, time)
		if (id == person_id) then
			return 1
		end
	end
	-------------------------------------------------
	if (table.foreach(memory_table, find_func) == 1) then
calls.leave("trigger_utility.seeEnemy",person_id)
		return true
	end
calls.leave("trigger_utility.seeEnemy",person_id)
	return false
end, 
--	  
hearShot = function(person_id)
calls.enter("trigger_utility.hearShot",person_id)
	local memory_table = trigger_service.person_observer.shots
	-------------------------------------------------
	local find_func = function(id, time)
		if (id == person_id) then
			return 1
		end
	end
	-------------------------------------------------
	if (table.foreach(memory_table, find_func) == 1) then
calls.leave("trigger_utility.hearShot",person_id)
		return true
	end
calls.leave("trigger_utility.hearShot",person_id)
	return false
end, 

-------------------------------------------------
--	
--	/ CP ( cp   )
addCP = function(team_id, cp)
calls.enter("trigger_utility.addCP",team_id)
	addCPEx(team_id, cp)
calls.leave("trigger_utility.addCP",team_id)
end, 

}